import logging


DB = 'D:/Francesco/Scuola/Politecnico/Magistrale/Tesi/sources/2023/dbV2.db'

class Insegnamento:
    def __init__(self, row):
        if row == None:
            return None
        self.id_collegio = row[0]
        self.tipo_laurea = row[1]
        self.nome_cdl = list([row[2]])
        self.a_acc = row[3]
        self.pd = row[4]
        self.categoria = row[5]
        self.cod_ins = list([row[6]])
        self.titolo = row[7]
        self.cfu = int(row[8])
        self.capo_aggr = row[9]
        self.n_incarico = row[10]
        self.org_prop = row[11]
        self.ID_INC = int(row[12])
        self.assegnazione = row[13]
        self.numAlfabetica = int(row[14])
        self.nomeAlfabetica = row[15]
        self.docenti, self.titolare = self.extractDocenti(row[16])
        self.note = row[17]
        self.anno = str(row[18])
        self.orientamento = list([row[19]])
        self.numIscritti = 0
        try:
            self.numIscritti = int(row[21])
        except:
            pass
            
    def __str__(self):
        return 'ID_INC: ' + str(self.ID_INC) + ' titolo: ' + self.titolo + ' orientamento: ' + str(self.orientamento) + ' cfu: ' + str(self.cfu) + ' cod_ins: ' + str(self.cod_ins) + '\nnome_cdl: ' + str(self.nome_cdl) +'\n' + str(self.docenti)
    
    def extractDocenti(self, strDocenti):
        if strDocenti is None:
            return list(), "Docente"
        setDocenti = set()
        titolare = "Docente"
        docs = strDocenti.split(';')
        for doc in docs:
            cognome = doc.split('(')[0].strip().title()
            setDocenti.add(cognome)
            if "tit" in doc:
                titolare = cognome
        return list(setDocenti), titolare


# oltre a X per i lab
symbols = set()   

class Allocazione:
    def __init__(self, row):
        self.cfu = row[0]
        self.titolo = row[6]
        try:
            self.num_slot = int(row[2])
        except ValueError:
            logging.warning("Types.Allocazione(): error parsing ore_totali per il corso: " + self.titolo)
            self.num_slot = 0
        self.nome_cdl = row[3]
        self.orientamento_gruppo = row[4]
        self.titolare = str(row[5]).title()
        try:
            self.ore_totali = float(row[1])
        except ValueError:
            logging.warning("Types.Allocazione(): error parsing num_slot per il corso: " + self.titolo)
            self.ore_totali = 0
        self.pianoAlloc = self.readPianoAlloc(row, 7, 7+35)
        self.ID_INC = str(row[42])
    
    def __str__(self) -> str:
        return "ID_INC: " + self.ID_INC + " titolo: " + self.titolo + " nome_cdl: " + self.nome_cdl
        
    def readPianoAlloc(self, row, idStart, idEnd):
        simbols = set()
        pianoAlloc = ['']*35
        for i in range(idStart,idEnd):
            if row[i] in ["X", "x", "R", "r", "5T", "?5T?"]:
                pianoAlloc[i-idStart] = "1"
            elif row[i] in ['', '?']:
                pass
            elif "led" in str(row[i]).lower():
                pianoAlloc[i-idStart] = "2"
            elif "laib" in str(row[i]).lower():
                pianoAlloc[i-idStart] = "3"
            elif "ladispe" in str(row[i]).lower():
                pianoAlloc[i-idStart] = "4"
            elif "acslab" in str(row[i]).lower():
                pianoAlloc[i-idStart] = "5"
            elif "labinf" in str(row[i]).lower():
                pianoAlloc[i-idStart] = "6"
            else:
                symbols.add(row[i])
        return pianoAlloc
